<?php

namespace Inside\Content\Console\Paragraphs;

use Inside\Console\Command;
use Inside\Content\Services\ConfigurationGenerator\ConfigurationGenerator;
use Inside\Content\Services\ConfigurationGenerator\ParagraphsGenerator;

class GenerateConfigurations extends Command
{
    protected $signature = 'inside:paragraph:config:generate';

    protected $description = 'Generate Drupal configuration for available paragraphs';

    public function handle(): void
    {
        $bundles = ParagraphsGenerator::load()->getAvailable();
        ConfigurationGenerator::load($bundles)->generate();

        $this->writeln('<fg=green>Count: <fg=yellow>'.collect($bundles)->count().' files generated!</>');
        $this->writeln('<fg=green>Location: <fg=yellow>'.config('generator.config.output').'</>');
        $this->writeln('');
        $this->warning('You can now run "php artisan inside:paragraph:config:import"');
        $this->writeln("\n");
    }
}
