<?php

namespace Inside\Content\Console\Paragraphs;

use Inside\Console\Command;
use Inside\Content\Services\ConfigurationGenerator\ConfigurationGenerator;
use Inside\Content\Services\ConfigurationGenerator\ParagraphsGenerator;

class EnableParagraph extends Command
{
    protected $signature = 'inside:paragraph:enable {name}';

    protected $description = 'Generate configuration to enable a new paragraph';

    public function handle(): void
    {
        if (! is_string($this->argument('name'))) {
            $this->writeln('name invalid.');

            return;
        }

        $bundles = ParagraphsGenerator::load()->enable($this->argument('name'))->getAvailable();
        ConfigurationGenerator::load($bundles)->generate();

        $this->writeln('<fg=green>Count: <fg=yellow>'.collect($bundles)->count().' files generated!</>');
        $this->writeln('<fg=green>Location: <fg=yellow>'.config('generator.config.output').'</>');
        $this->writeln('');
        $this->warning('You can now run "php artisan inside:paragraph:config:import"');
        $this->writeln("\n");
    }
}
