<?php

namespace Inside\Content\Console;

use Illuminate\Support\Facades\File;
use Inside\Console\Command;
use Inside\Content\Facades\ContentImporter;

class ImportContentCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'inside:import {config} {file} {--silent}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Importer des contenus dans inside';

    /**
     * Importation config
     *
     * @var array
     */
    protected $config;

    /**
     * InsideImport constructor.
     */
    public function __construct()
    {
        parent::__construct();

        $this->config = config('imports');
    }

    public function handle(): void
    {
        /** @var string $configName */
        $configName = $this->argument('config');
        /** @var string $file */
        $file = $this->argument('file');
        $silent = $this->option('silent');

        $supported = array_keys($this->config);

        // Check required parameters
        if (! in_array($configName, $supported)) {
            $this->error(
                'La configuration ['.$configName.'] n\'est pas supporté. Seules les configurations ['.implode(
                    ', ',
                    $supported
                ).'] peuvent être utilisée'.(count($supported) > 1 ? 's' : '').'.'
            );

            return;
        }

        if (! File::exists($file) || ! File::isFile($file) || ! File::isReadable($file)) {
            $this->error('Le fichier ['.$file.'] n\'existe pas ou ne peut pas être lu.');

            return;
        }
        $config = $this->config[$configName];

        $config['file'] = $file;
        $config['silent'] = $silent;

        $driver = $config['format']['driver'] ?? 'csv';

        ContentImporter::import($driver, $config, ! $silent ? $this->getOutput() : null);
    }
}
