<?php

namespace Inside\Content\Console;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Inside\Console\Command;

class FindMissingFilesCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:files:missing';

    /**
     * @var string
     */
    protected $signature = 'inside:files:missing';

    /**
     * @var string
     */
    protected $description = 'Find all missing files';

    /**
     * Handle index command
     */
    public function handle(): void
    {
        $files = DB::table('file_managed');

        $missing = $files
          ->pluck('uri')
          ->map(fn (string $uri) => str($uri)->after('public://'))
          ->reject(fn (string $uri) => Storage::exists($uri));

        $urls = $missing->map(function (string $uri) {
            $content = $this->retrieveContentThroughImage($uri) ?? $this->retrieveContentThroughFile($uri);

            if ($content) {
                try {
                    // @phpstan-ignore-next-line
                    $bundle = $content->bundle;
                    // @phpstan-ignore-next-line
                    $uuid_host = $content->uuid;

                    $content = call_user_func(type_to_class($bundle).'::where', 'uuid_host', $uuid_host)->firstOrFail();

                    return url('edit/'.$bundle.'/'.$content->uuid).' Not found: '.$uri;
                } catch (\Exception) {
                    return null;
                }
            }

            return null;
        })->filter();

        dd($urls);
    }

    protected function retrieveContentThroughImage(string $uri): ?object
    {
        $contentQuery = DB::table('file_managed')
          ->join(
              table: 'node__field_image',
              first: 'file_managed.fid',
              operator: '=',
              second: 'node__field_image.field_image_target_id'
          )
          ->leftJoin('node', function ($join) {
              $join->on('node.nid', '=', 'node__field_image.entity_id');
              $join->on('node.type', '=', 'node__field_image.bundle');
          })
          ->where('uri', 'public://'.$uri);

        return $contentQuery->first();
    }

    protected function retrieveContentThroughFile(string $uri): ?object
    {
        $contentQuery = DB::table('file_managed')
          ->join(
              table: 'node__field_file',
              first: 'file_managed.fid',
              operator: '=',
              second: 'node__field_file.field_file_target_id'
          )
          ->leftJoin('node', function ($join) {
              $join->on('node.nid', '=', 'node__field_file.entity_id');
              $join->on('node.type', '=', 'node__field_file.bundle');
          })
          ->where('uri', 'public://'.$uri);

        return $contentQuery->first();
    }
}
