<?php

namespace Inside\Content\Console;

use Inside\Console\Command;
use Inside\Content\Services\GedDuplicationService;

/**
 * Class ExportGedCommand
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class DuplicateGedCommand extends Command
{
    protected $name = 'inside:ged:duplicate';

    protected $signature = 'inside:ged:duplicate {--prefix=} {--folder=} {--debug}?';

    protected $description = 'Duplicate ged directories and files';

    public function __construct(private GedDuplicationService $gedDuplicationService)
    {
        parent::__construct();
    }

    public function handle(): void
    {
        /**
         * @var ?string $rootFolder
         */
        $rootFolder = $this->option('folder');

        /**
         * @var string $prefix
         */
        $prefix = $this->option('prefix') ?? '[copie]';

        /**
         * @var ?string $debug
         */
        $debug = $this->option('debug');

        $this->info('Starting duplication...');

        $stats = $this->gedDuplicationService
            ->setPrefix($prefix)
            ->setRootFolder($rootFolder)
            ->execute();

        $this->info('Duplication completed successfully!');
        foreach ($stats as $status => $data) {
            foreach ($data as $contentType => $result) {
                $this->info(sprintf('%s %s %s', count($result), $contentType, $status));
            }
        }

        if ($debug) {
            dump($stats);
        }
    }
}
