<?php

namespace Inside\Content\Console;

use Illuminate\Filesystem\Filesystem;
use Illuminate\Support\Carbon;
use Inside\Console\Command;
use Pion\Laravel\ChunkUpload\Storage\ChunkStorage;

class CleanUploadsCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:uploads:clean';

    /**
     * @var string
     */
    protected $signature = 'inside:uploads:clean';

    /**
     * @var string
     */
    protected $description = 'Clean all old uploads fiels';

    /**
     * Handle index command
     */
    public function handle(ChunkStorage $storage, Filesystem $fileSystem): void
    {
        $this->write("Nettoyage des fichiers d'upload partiels");
        // Delete old *.part files
        $storage->oldChunkFiles()->each(function ($file) {
            $file->delete();
        });
        $this->writeResult(true);

        $this->write('Nettoyage des fichiers uploadés jamais utilisés');

        // Delete old complete upload files ( it means, someone upload a file but did not save the content where the file should be attached to )
        $chunksDirectories = collect(
            $fileSystem->directories(storage_path('app/chunks'))
        );

        $yesterday = today()->subDay();
        $chunksDirectories->each(
            function ($directory) use ($yesterday, $fileSystem) {
                $matches = [];
                // Only keep inside logs for X days ( scheduler, import log, should be delete )
                if (preg_match('/\/(\d{10})$/is', $directory, $matches)) {
                    $date = get_date($matches[1]);
                    if ($date?->isAfter($yesterday)) {
                        return;
                    }
                }

                $fileSystem->deleteDirectory($directory);
            }
        );
        $this->writeResult(true);
    }
}
