<?php

declare(strict_types=1);

namespace Inside\Content\Console;

use Inside\Console\Command;
use Inside\Content\Jobs\AddRevisionOnExistingContentsIfNeeded;
use Inside\Content\Models\Revision;

final class CleanRevisionOfDeletedContentCommand extends Command
{
    protected $name = 'inside:revision:clean';

    protected $signature = 'inside:revision:clean';

    protected $description = 'Supprimer les versions des contenus supprimées';

    public function handle(): int
    {
        Revision::query()->chunk(20, function ($revisions) {
            foreach ($revisions as $revision) {
                if ($revision->content === null) {
                    $this->info("Suppression de la révision #{$revision->id} (contenu supprimé)");
                    $revision->delete();
                }
            }
        });

        return Command::SUCCESS;
    }
}
