<?php

namespace Inside\Content\Chat\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Chat\Events\ChatEvent;
use Inside\Content\Chat\Models\Chat;

/**
 * Class ChatController
 */
class ChatController extends Controller
{
    /**
     * Get all chat messages
     */
    public function fetchAllMessages(): JsonResponse
    {
        return response()->json(Chat::with('user.information')->get());
    }

    /**
     * Post a chat message
     */
    public function sendMessage(Request $request): JsonResponse
    {
        /** @var User $user */
        $user = Auth::user();
        $chat = $user->messages()->create(
            [
                'message' => $request->message,
            ]
        );

        /** @var Chat $chatModel */
        $chatModel = $chat->load('user.information');
        broadcast(new ChatEvent($chatModel))->toOthers();

        return response()->json(['status' => 'success']);
    }
}
