<?php

namespace Inside\Content\Calendars;

use Inside\Content\Contracts\CalendarInterface;

final class Outlook implements CalendarInterface
{
    public function generate(string $title, ?string $location, int $startDate, ?int $endDate, ?string $description, ?string $url): string
    {
        $start = date(DATE_ATOM, $startDate);
        $end = $endDate ? date(DATE_ATOM, $endDate) : null;

        if ($url) {
            $body = "<a href=\"$url\">$url</a><p>$description</p>";
        } else {
            $body = $description;
        }

        $query = http_build_query([
            'allday' => 'false',
            'path' => '/calendar/action/compose',
            'rru' => 'addevent',
            'subject' => $title,
            'location' => $location,
            'startdt' => $start,
            'enddt' => $end,
            'body' => $body,
        ]);

        return "https://outlook.live.com/calendar/deeplink/compose?$query";
    }
}
