<?php

namespace Inside\Content\Calendars;

use Carbon\Carbon;
use Carbon\CarbonInterface;
use Inside\Content\Contracts\CalendarInterface;

final class Google implements CalendarInterface
{
    public function generate(string $title, ?string $location, int $startDate, ?int $endDate, ?string $description, ?string $url): string
    {
        $start = date('Ymd\THis\Z', $startDate);
        $end = $endDate ? date('Ymd\THis\Z', $endDate) : null;

        if (! empty($url)) {
            $details = "<a href=\"$url\">$url</a><p>$description</p>";
        } else {
            $details = $description;
        }

        $query = http_build_query([
            'action' => 'TEMPLATE',
            'ctz' => 'Europe/Paris',
            'text' => $title,
            'dates' => "$start/$end",
            'location' => $location,
            'details' => $details,
        ]);

        return "https://www.google.com/calendar/render?$query";
    }
}
