<?php

namespace Inside\Content\Seeders;

use Illuminate\Database\Seeder;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class SeniorityAnniversarySeeder extends Seeder
{
    public function run()
    {
        $bridge = new BridgeContent();
        $bridgeContentType = new BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'seniority_anniversary',
            options: [
                'name' => 'seniority_anniversary',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'en' => 'Work anniversaries',
                    'fr' => 'Anniversaire d\'ancienneté',
                    'es' => 'Aniversario de antigüedad',
                    'pt' => 'Aniversário de antiguidade',
                    'de' => 'Dienstjubiläum',
                    'nl' => 'Dienstjubileum',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_TIMESTAMP_WIDGET,
                    'settings' => [],
                    'weight' => 6,
                    'group' => 'group_contact',
                ],
                'type' => BridgeContentType::TIMESTAMP_FIELD,
                'front_field_config' => json_encode([
                    'input' => 'input-day',
                    'toDate' => true,
                ]),
                'settings' => [
                    'cardinality' => 1,
                ],
            ]
        );

        $adsLanguages = collect([
            'en' => 'Work anniversaries',
            'fr' => 'Anniversaires d\'ancienneté',
            'es' => 'Aniversarios de antigüedad',
            'pt' => 'Aniversários de antiguidade',
            'de' => 'Dienstjubiläen',
            'nl' => 'Dienstjubilea',
        ])->only(list_languages());

        $adsLanguages->each(function ($title, $lang) use ($bridge) {
            $adsCustomPage = type_to_class('custom')::query()->where('custom_slug', 'work-anniversaries')->where('langcode', $lang)->exists();

            if ($adsCustomPage) {
                return;
            }

            $data = collect([
                'langcode' => $lang,
                'title' => $title,
                'custom_slug' => 'work-anniversaries',
                'redirection_page' => 'WorkAnniversariesListingPage',
            ]);

            $bridge->contentInsert(
                type: 'custom',
                data: $data->toArray(),
            );
        });
    }
}
