<?php

namespace Inside\Content\Seeders;

use Illuminate\Database\Seeder;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

class DefaultCustomsSeeder extends Seeder
{
    private BridgeContent $bridge;

    private function getBridge(): BridgeContent
    {
        return $this->bridge ??= new BridgeContent();
    }

    private function createIfNotExists(array $preparedData, string $language, bool $isHostContent): ?string
    {
        $hostUuid = null;
        $customPageTest = Custom::where(['redirection_page' => $preparedData['redirection_page'], 'langcode' => $language])->first();

        if ($customPageTest) {
            return null;
        }

        $newCustomPageUuid = $this->getBridge()->contentInsert('custom', $preparedData);

        if ($isHostContent === true) {
            $newCustomPageData = Custom::find($newCustomPageUuid);
            $hostUuid = $newCustomPageData->uuid_host;
        }

        return $hostUuid;
    }

    public function run(): void
    {
        $newContentsList = [
            [
                'title' => [
                    'fr' => 'Événements',
                    'en' => 'Events',
                    'es' => 'Eventos',
                    'pt' => 'Eventos',
                    'de' => 'Veranstaltungen',
                    'nl' => 'Evenementen',
                ],
                'redirection_page' => 'EventsCalendarPage',
                'custom_slug' => 'calendar',
            ],
            [
                'title' => [
                    'fr' => 'Groupes collaboratifs',
                    'en' => 'Collaborative groups',
                    'es' => 'Grupos de colaboración',
                    'pt' => 'Grupos de colaboração',
                    'de' => 'Kollaborative Gruppen',
                    'nl' => 'Samenwerkingsgroepen',
                ],
                'redirection_page' => 'TeamsListingPage',
                'custom_slug' => 'groups',
            ],
            [
                'title' => [
                    'fr' => 'Actualités',
                    'en' => 'News',
                    'es' => 'Noticias',
                    'pt' => 'Notícias',
                    'de' => 'Nachrichten',
                    'nl' => 'Nieuws',
                ],
                'redirection_page' => 'NewsListingPage',
                'custom_slug' => 'news',
            ],
            [
                'title' => [
                    'fr' => 'Annuaire',
                    'en' => 'Directory',
                    'es' => 'Directorio',
                    'pt' => 'Diretório',
                    'de' => 'Verzeichnis',
                    'nl' => 'Directory',
                ],
                'redirection_page' => 'DirectoryPage',
                'custom_slug' => 'directory',
            ],
            [
                'title' => [
                    'fr' => 'Bibliothèque',
                    'en' => 'Library',
                    'es' => 'Biblioteca',
                    'pt' => 'Biblioteca',
                    'de' => 'Bibliothek',
                    'nl' => 'Bibliotheek',
                ],
                'redirection_page' => 'GedPage',
                'custom_slug' => 'ged',
            ],
            [
                'title' => [
                    'fr' => 'Outils',
                    'en' => 'Tools',
                    'es' => 'Herramientas',
                    'pt' => 'Ferramentas',
                    'de' => 'Tools',
                    'nl' => 'Gereedschap',
                ],
                'redirection_page' => 'ToolsPage',
                'custom_slug' => 'tools',
            ],
            [
                'title' => [
                    'fr' => 'Implantations',
                    'en' => 'Locations',
                    'es' => 'Ubicaciones',
                    'pt' => 'Localizações',
                    'de' => 'Standorte',
                    'nl' => 'Locaties',
                ],
                'redirection_page' => 'MapPage',
                'custom_slug' => 'map',
            ],
            [
                'title' => [
                    'fr' => 'Congés',
                    'en' => 'Leave',
                    'es' => 'Deja',
                    'pt' => 'Folhas',
                    'de' => 'Leave',
                    'nl' => 'Verlaat',
                ],
                'redirection_page' => 'LeaveRequestFormPage',
                'custom_slug' => 'leave-request',
            ],
        ];

        $mainLanguage = config('app.locale');
        $otherLanguages = collect(list_languages())->reject($mainLanguage)->values();

        foreach ($newContentsList as $content) {
            $uuidHost = $this->createIfNotExists(
                [
                    'title' => $content['title'][$mainLanguage],
                    'redirection_page' => $content['redirection_page'],
                    'custom_slug' => $content['custom_slug'],
                    'langcode' => $mainLanguage,
                ],
                $mainLanguage,
                true
            );

            if ($uuidHost === null) {
                continue;
            }

            foreach ($otherLanguages as $language) {
                if (! isset($content['title'][$language])) {
                    continue;
                }

                $translatedContent = [
                    'title' => $content['title'][$language],
                    'redirection_page' => $content['redirection_page'],
                    'custom_slug' => $content['custom_slug'],
                    'langcode' => $language,
                    'uuid_host' => $uuidHost,
                ];

                $this->createIfNotExists($translatedContent, $language, false);
            }
        }
    }
}
