<?php

namespace Inside\Content\Seeders;

use Illuminate\Database\Seeder;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

class AlphabetPageSeeder extends Seeder
{
    public function run()
    {
        $alphabetPageTitles = [
            'fr' => 'Abécédaire',
            'en' => 'Alphabet',
            'es' => 'Abecedario',
            'pt' => 'Abecedário',
            'de' => 'Alphabet',
            'nl' => 'Alfabet',
        ];
        $alphabetPage = [
            'redirection_page' => 'AlphabetBooksPage',
            'custom_slug' => 'alphabet',
        ];

        $mainLanguage = config('app.locale');
        $alphabetPageContent = Custom::where(['redirection_page' => $alphabetPage['redirection_page'], 'langcode' => $mainLanguage])->first();
        if ($alphabetPageContent) {
            return null;
        }

        $bridgeContent = new BridgeContent();
        $alphabetPageContentUuid = $bridgeContent->contentInsert(
            'custom',
            array_merge($alphabetPage, ['langcode' => $mainLanguage, 'title' => $alphabetPageTitles[$mainLanguage]]),
        );

        $alphabetPageContent = Custom::find($alphabetPageContentUuid);
        $hostUuid = $alphabetPageContent->uuid_host;
        collect(list_languages())
            ->diff([$mainLanguage])
            ->each(function ($language) use ($bridgeContent, $alphabetPageTitles, $alphabetPage, $hostUuid) {
                $bridgeContent->contentInsert(
                    'custom',
                    array_merge($alphabetPage, [
                        'uuid_host' => $hostUuid,
                        'langcode' => $language,
                        'title' => $alphabetPageTitles[$language],
                    ]), true, true);
            });
    }
}
