<?php

namespace Inside\Content\Seeders;

use Illuminate\Database\Seeder;
use Inside\Host\Bridge\BridgeContent;

class AdsCustomPagesSeeder extends Seeder
{
    public function run()
    {
        $bridge = new BridgeContent();

        $adsLanguages = collect([
            'fr' => 'Petites annonces',
            'en' => 'Ads',
            'es' => 'Anuncios',
            'pt' => 'Anúncios',
            'de' => 'Anzeigen',
            'nl' => 'Advertenties',
        ])->only(list_languages());

        $adsLanguages->each(function ($title, $lang) use ($bridge) {
            $adsCustomPage = type_to_class('custom')::query()->where('custom_slug', 'ads')->where('langcode', $lang)->exists();

            if ($adsCustomPage) {
                return;
            }

            $data = collect([
                'langcode' => $lang,
                'title' => $title,
                'custom_slug' => 'ads',
                'redirection_page' => 'AdsListingPage',
            ]);

            $bridge->contentInsert(
                type: 'custom',
                data: $data->toArray(),
            );
        });
    }
}
