<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name'  => 'text_two_columns',
        'title' => [
            'fr' => 'Contenu sur deux colonnes',
            'en' => 'Content on two columns',
        ],
    ],
    'fields'  => [
        [
            'type'                => BridgeContentType::WYSIWYG_FIELD,
            'name'                => 'text_left',
            'searchable'          => true,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'Contenu de la colonne de gauche',
                'en' => 'Left column content',
            ],
            'description'         => [],
            'widget'              => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
        ],
        [
            'type'                => BridgeContentType::WYSIWYG_FIELD,
            'name'                => 'text_right',
            'searchable'          => true,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Contenu de la colonne de droite',
                'en' => 'Right column content',
            ],
            'description'         => [],
            'widget'              => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
        ],
    ],
];
