<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'name'  => 'fetched_contents',
        'title' => [
            'fr' => 'Récupération de contenu',
            'en' => 'Fetch content',
        ],
    ],
    'fields'  => [
        [
            'name' => 'fetched_title',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Titre',
                'en' => 'Title',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content_type',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Type de contenu',
                'en' => 'Content Type',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'limit',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Limite',
                'en' => 'Limit',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'show_pagination',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'default' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Afficher la pagination',
                'en' => 'Show pagination',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'sort',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Ordre',
                'en' => 'Order',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'selection_type',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Selection',
                'en' => 'Selection',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'selection',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'fetch_link',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Lien',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'max_length' => 255,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'link_label',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Label du lien',
                'en' => 'Link label',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'custom_order',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Ordre custom',
                'en' => 'Custom Order',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ],
];
