<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Models\InsidePages;

class AddLangcodeToInsidePages extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        if (Schema::hasTable('inside_pages') && ! Schema::hasColumn('inside_pages', 'langcode')) {
            Schema::table('inside_pages', function (Blueprint $table) {
                $table->char('langcode', 2)->nullable();
            });

            InsidePages::all()->each(function ($page) {
                $page->langcode = config('app.locale', 'fr');
                $page->save();
            });
        }
    }
}
