<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePagesTable extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('inside_pages')) {
            return;
        }

        Schema::create('inside_pages', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title');
            $table->json('json')->nullable();
            $table->boolean('status')->default(false);
            $table->string('path');
            $table->timestamps();
        });
    }
}
