<?php

use Drupal\Core\Entity\EntityTypeInterface;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class DeleteTwitterFromParagraph extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $relatedModels = InsideSchema::getModelsWithField('content');

        collect($relatedModels)->each(function ($model) use ($bridge) {
            $allTargetTypes = InsideSchema::getFieldOptions($model, 'content')['target'];

            $targetTypesWithoutTwitter = collect($allTargetTypes)
                ->reject(fn ($type) => $type === 'tweet')
                ->values()
                ->toArray();

            if (collect($allTargetTypes)->contains('tweet')) {
                $bridge->contentTypeCreateOrUpdateField(
                    type: $model,
                    fieldName: 'content',
                    options: [
                        'name' => 'content',
                        'type' => BridgeContentType::SECTION_FIELD,
                        'settings' => [
                            'target_type' => $targetTypesWithoutTwitter,
                            'cardinality' => -1,
                        ],
                    ],
                );
            }
        });
    }
}
