<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Content\Models\Contents\MediaViewer;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class MakeTitleUnrequiredForMediaViewer extends Migration
{
    public function up(): void
    {
        if (
            ! InsideSchema::hasContentType('media_viewer')
        ) {
            return;
        }

        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'media_viewer',
            fieldName: 'hide_title',
            entityTypeId: 'node',
            options: [
                'name' => 'hide_title',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Afficher le titre',
                    'en' => 'Display the title',
                    'es' => 'Mostrar el título',
                    'de' => 'Titel anzeigen',
                    'pt' => 'Exibir o título',
                    'nl' => 'Titel weergeven',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => true,
            ],
            weight: 2
        );

        MediaViewer::all()->each(
            function ($content) use ($bridgeContent) {
                try {
                    $bridgeContent->contentUpdate('media_viewer', ['uuid' => $content->uuid, 'hide_title' => true]);
                } catch (Exception) {
                }
            }
        );
    }
}
