<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\InsidePages;
use Inside\Host\Bridge\BridgeContentType;

class UpdateInsidePagesForMobile extends Migration
{
    public function up(): void
    {
        $insidePages = InsidePages::all();
        $insidePages->each(function ($insidePage) {
            $jsonPage = json_decode($insidePage->json, true);
            $transformedData = collect($jsonPage)->map(function ($section, $sectionIndex) {
                $sectionMobileOrderIndex = 0;
                $section['display_in_mobile'] = true;
                if (isset($section['columns']) && is_array($section['columns'])) {
                    $section['columns'] = collect($section['columns'])->map(function ($column) use (&$sectionMobileOrderIndex) {
                        $columnDesktopOrderIndex = 0;
                        if (isset($column['components']) && is_array($column['components'])) {
                            $column['components'] = collect($column['components'])->map(function ($component) use (&$sectionMobileOrderIndex, &$columnDesktopOrderIndex) {
                                $component['display_in_mobile'] = true;
                                $component['order'] = [
                                    'desktop' => $columnDesktopOrderIndex,
                                    'mobile' => $sectionMobileOrderIndex,
                                ];
                                $columnDesktopOrderIndex++;
                                $sectionMobileOrderIndex++;

                                return $component;
                            })->toArray();
                        }

                        return $column;
                    })->toArray();
                }
                $section['order'] = [
                    'desktop' => $sectionIndex,
                    'mobile' => $sectionIndex,
                ];

                return $section;
            })->values()->toArray();

            $insidePage->json = json_encode($transformedData);
            $insidePage->save();
        });
    }
}
