<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddDescriptionForNewsCategoriesListing extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (
            ! Schema::hasContentType('news_categories_listings') ||
            ! Schema::hasContentType('news_categories')
        ) {
            return;
        }

        $bridge = new BridgeContentType();

        $bridge->contentTypeUpdateField(
            type: 'news_categories',
            fieldName: 'news_categories_listings',
            options: [
                'name' => 'news_categories_listings',
                'required' => false,
                'title' => [
                    'fr' => 'Listing catégorie d\'actualités',
                    'en' => 'News categories listing',
                    'es' => 'Listado de categorías de noticias',
                    'pt' => 'Listagem de categorias de notícias',
                    'de' => 'Nachrichtenkategorienliste',
                    'nl' => 'Lijst van nieuwscategorieën',
                ],
                'description' => [
                    'fr' => "Choisissez une page de listing sur laquelle la catégorie doit remonter. Si aucune page n’est sélectionnée elle remontera sur la page personnalisée 'actualité'.",
                    'en' => 'Choose a listing page on which the category should appear. If no page is selected, it will appear on the custom "news" page.',
                    'es' => 'Elija una página de listado en la que debe aparecer la categoría. Si no se selecciona ninguna página, aparecerá en la página personalizada "noticias".',
                    'nl' => 'Kies een lijstpagina waarop de categorie moet verschijnen. Als er geen pagina is geselecteerd, verschijnt deze op de aangepaste "nieuws"-pagina.',
                    'de' => 'Wählen Sie eine Listen-Seite aus, auf der die Kategorie erscheinen soll. Wenn keine Seite ausgewählt ist, erscheint sie auf der benutzerdefinierten "Nachrichten"-Seite.',
                    'pt' => 'Escolha uma página de listagem na qual a categoria deve aparecer. Se nenhuma página for selecionada, ela aparecerá na página personalizada "notícias".',
                ],
            ]
        );

        Artisan::call('models:rebuild');
    }
}
