<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Migrations\CreateContentTypes;

class AddContentUuidToInsideLogs extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        if (Schema::hasTable('inside_logs') && ! Schema::hasColumn('inside_logs', 'content_uuid')) {
            Schema::table('inside_logs', function (Blueprint $table) {
                $table->string('content_uuid', 36)->nullable()->after('content_type');
            });
        }

        $this->finishUp();
    }
}
