<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class EnableCascadeDeleteOnTabsSpaces extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        if (
            Schema::hasContentType('tabs_spaces') &&
            Schema::hasContentType('tabs') &&
            Schema::hasContentType('tabs_pages')
        ) {
            $bridge->contentTypeUpdate('tabs_spaces', ['deletion_strategy' => 'only_parent']);
            $bridge->contentTypeUpdate('tabs', ['deletion_strategy' => 'only_parent']);
            $bridge->contentTypeUpdate('tabs_pages', ['deletion_strategy' => 'only_parent']);

            $bridge->contentTypeUpdateField('tabs', 'tabs_spaces', ['reference_is_a_parent' => true]);
            $bridge->contentTypeUpdateField('tabs_pages', 'tabs', ['reference_is_a_parent' => true]);
        }
    }
}
