<?php

use Drupal\node\Entity\NodeType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Arr;
use Inside\Content\Facades\Schema;
use Inside\Host\Exodus\Services\ContentTypeStatusService;

class SetTranslatableIfMissingInThirdPartyInside extends Migration
{
    public function up(): void
    {
        new Inside\Host\Services\DrupalService();

        $translation_manager = Drupal::service('content_translation.manager');
        $types = app(ContentTypeStatusService::class)->reject(fn ($config) => Arr::has($config, 'third_party_settings.inside.translatable'))->keys()->toArray();

        foreach ($types as $type) {
            /** @phpstan-ignore-next-line */
            $nodeType = NodeType::load($type);

            if ($nodeType && is_null($nodeType->getThirdPartySetting('inside', 'translatable', null))) {
                $nodeType->setThirdPartySetting('inside', 'translatable', $translation_manager->isEnabled('node', $type));
                $nodeType->save();
            }
        }
    }
}
