<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldToSomeContentTypes extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contentTypes = [
            'tools_categories_listings',
            'tabs_spaces',
            'pages',
        ];

        foreach ($contentTypes as $contentType) {
            if (Schema::hasContentType($contentType)) {
                $bridge->contentTypeCreateOrUpdateField(
                    type: $contentType,
                    fieldName: 'color',
                    options: [
                        'name' => 'color',
                        'searchable' => false,
                        'translatable' => true,
                        'search_result_field' => false,
                        'searchable_filter' => false,
                        'required' => false,
                        'weight' => -3,
                        'title' => [
                            'fr' => 'Couleur du titre et de l’introduction',
                            'en' => 'Title and introduction color',
                            'es' => 'Color del título y la introducción',
                            'pt' => 'Cor do título e da introdução',
                            'de' => 'Farbe von Titel und Einleitung',
                            'nl' => 'Kleur van titel en inleiding',
                        ],
                        'widget' => [
                            'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                            'settings' => [],
                            'weight' => -3,
                        ],
                        'type' => BridgeContentType::TEXT_FIELD,
                        'settings' => [
                            'max_length' => 255,
                            'is_ascii' => false,
                            'case_sensitive' => false,
                            'cardinality' => 1,
                        ],
                    ],
                    weight: -2
                );
            }
        }

        Artisan::call('models:rebuild');
    }
}
