<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class UpdateGroupOptionImage extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        if (! InsideSchema::hasField(modelName: 'users', fieldName: 'image')) {
            return;
        }

        $bridge->changeFieldFormOptions(
            type: 'users',
            fieldName: 'image',
            displayed: false,
            group: 'group_options'
        );

        Artisan::call('models:rebuild');
    }
}
