<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Storage;
use Inside\Content\Models\Contents\Documents;

class MigrateDocumentsForAdvancedTables extends Migration
{
    public function up(): void
    {
        $advancedTableSections = Illuminate\Support\Facades\DB::table(section_type_to_table('advanced_table'))->where(
            'advanced_table',
            'like',
            '%ged_documents%'
        )->get();

        foreach ($advancedTableSections as $advancedTableSection) {
            $baseAdvancedTableSection = $advancedTableSection->advanced_table;
            $advancedTable = stripcslashes($baseAdvancedTableSection);

            preg_match_all('/<ged-documents[^>]*documents=\\"([0-9a-fA-F\-]+(?:,[0-9a-fA-F\-]+)*)\\"/i', $advancedTable, $matches);

            if (empty($matches[1])) {
                continue;
            }
            $uuids = array_unique($matches[1]);

            foreach ($uuids as $uuidList) {
                $uuids = explode(',', $uuidList);

                $documentsContents = Documents::whereIn('uuid', $uuids)->get();

                $documents = [];

                foreach ($uuids as $uuid) {
                    try {
                        $document = $documentsContents->firstWhere('uuid', $uuid);

                        $documents[] = [
                            'uuid' => $uuid,
                            'title' => $document->title,
                            'file' => [
                                'mimetype' => Storage::disk('local')->mimeType($document->file),
                                'path' => "files/{$document->uuid}/documents/{$document->file}",
                                'size' => Storage::disk('local')->size($document->file),
                                'basename' => $document->file,
                            ],
                        ];
                    } catch (\Exception $e) {
                        Log::error('[Migrate documents] '.$e->getMessage());

                        $documents[] = [
                            'uuid' => 'not-found',
                            'title' => 'unknown',
                            'file' => [
                                'mimetype' => 'application/octet-stream',
                                'path' => 'not-found',
                                'size' => 0,
                                'basename' => 'unknown',
                            ],
                        ];
                    }
                }

                $encoded = rawurlencode(json_encode($documents));

                $baseAdvancedTableSection = str_replace($uuidList, $encoded, $baseAdvancedTableSection);
            }

            DB::table(section_type_to_table('advanced_table'))
                ->where('uuid', $advancedTableSection->uuid)
                ->update([
                    'advanced_table' => $baseAdvancedTableSection,
                ]);
        }
    }
}
