<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class FixLanguageToolsCategoriesListings extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        if (Schema::hasModel('tools_categories_listings')
            && Schema::getModelOptions('tools_categories_listings')['translatable']
            && Schema::hasField('tools_categories_listings', 'langcode')
            && ! Schema::getFieldOptions('tools_categories_listings', 'langcode')['displayed']) {
            $bridge->changeFieldFormOptions('tools_categories_listings', 'langcode', true, 'group_advanced_options');
        }
    }
}
