<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Content\Models\Contents\ImageStyles;
use Inside\Content\Models\Contents\Users;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Support\Str;

class UpdateImageStyles extends Migration
{
    use HasConsole;

    protected array $styles = [
        [
            'title'                    => 'image_resume',
            'field_width'              => 150,
            'field_height'             => 100,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => false,
        ],
        [
            'title'                    => 'image_card_3xs',
            'field_width'              => 360,
            'field_height'             => 78,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => false,
        ],
        [
            'title'                    => 'image_card_xxs',
            'field_width'              => 360,
            'field_height'             => 124,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => false,
        ],
        [
            'title'                    => 'image_card_xs',
            'field_width'              => 360,
            'field_height'             => 152,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => false,
        ],
        [
            'title'                    => 'image_card_s',
            'field_width'              => 360,
            'field_height'             => 200,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => false,
        ],
        [
            'title'                    => 'image_card_m',
            'field_width'              => 360,
            'field_height'             => 248,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => false,
        ],
        [
            'title'                    => 'image_card_l',
            'field_width'              => 360,
            'field_height'             => 304,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => false,
        ],
    ];

    public function up(): void
    {
        $imageCardStyle = ImageStyles::where('title', 'image_card')->first()?->uuid;
        if (! $imageCardStyle) {
            return;
        }

        $bridgeContentType = new BridgeContentType();
        $bridge = new BridgeContent();
        $bridge->contentUpdate(
            'image_styles',
            [
                'uuid'   => ImageStyles::where('title', 'image_card')->first()?->uuid,
                'resizable' => 0,
            ]
        );

        $langcode = config('app.locale', 'fr');

        $author = Users::where('email', config('app.technical_mail'))->first();

        foreach ($this->styles as $style) {
            $style['type'] = 'node';
            $style['bundle'] = 'image_styles';
            $style['langcode'] = $langcode;
            $style['author'] = $author->uuid;
            $bridge->contentInsert('image_styles', $style);
        }

        foreach (InsideSchema::getAllFieldsListingOfType('image') as $type => $fields) {
            if (Str::endsWith($type, '_menus')) {
                continue;
            }

            $this->writeln(
                'Mise-à-jour du <fg=blue>'.(InsideSchema::isSectionType($type) ? 'paragraphe' : 'contenu')
                .'</> <fg=cyan>'.$type.'</>'
            );

            foreach ($fields as $fieldName) {
                try {
                    $bridgeContentType->updateFieldOptions(
                        $type,
                        $fieldName,
                        [
                            'type'    => BridgeContentType::IMAGE_FIELD,
                            'search'  => [
                                'searchable'          => 0,
                                'global_searchable'   => 0,
                                'search_result_field' => 0,
                                'searchable_filter'   => 0,
                            ],
                            'special' => [
                                'image_styles' => ImageStyles::pluck('title')->toArray(),
                            ],
                        ]
                    );
                    $this->writeln(' <fg=green>✔</fg=green>');
                } catch (Throwable $e) {
                    $this->writeln(' <fg=red>✘</fg=red>');
                    $this->writeln('<fg=red;bg=white>'.$e->getMessage().'</>');
                    continue;
                }
            }
        }
    }
}
