<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\ContentBlueprints;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class SetFlashNewsTranslatable extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (! Schema::hasModel('flash_news') || Schema::getModelOptions('flash_news')['translatable']) {
            return;
        }

        ContentBlueprints::generateContent('flash_news');

        if (count(list_languages()) <= 1) {
            return;
        }

        $this->getBridge()?->changeFieldFormOptions('flash_news', 'langcode', true, 'group_advanced_options');
    }
}
