<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Content\Models\Contents\Custom;
use Inside\Content\Models\Contents\ToolsCategoriesListings;
use Inside\Menu\Models\HeaderMenuLink;

class FixHeaderTools extends Migration
{
    public function up(): void
    {
        if (in_array(strtolower(config('app.code')), ['gsia', 'imer', 'syct'])) {
            return;
        }

        if (! InsideSchema::hasContentType('tools_categories_listings')) {
            return;
        }

        $menuHeader = HeaderMenuLink::query()->where('page', 'ToolsPage')
            ->where('link', 'LIKE', '%tools_categories_listings%')
            ->update([
                'page' => null,
            ]);

        $brokenCustomMenu = HeaderMenuLink::query()->where('page', null)
            ->where('link', 'LIKE', '%custom%')
            ->pluck('link', 'langcode')
            ->map(fn ($link) => explode('|', $link)[1]);

        if ($brokenCustomMenu->isEmpty()) {
            return;
        }

        $toolsCustom = Custom::query()->whereIn('uuid', $brokenCustomMenu)
            ->where('redirection_page', 'ToolsPage')
            ->where('status', 0)
            ->pluck('uuid', 'langcode');

        if ($toolsCustom->isEmpty()) {
            return;
        }

        $menuTools = $brokenCustomMenu->intersect($toolsCustom);

        if ($menuTools->isEmpty()) {
            return;
        }

        $listingPages = ToolsCategoriesListings::whereIn('langcode', $menuTools->keys())
            ->pluck('uuid', 'langcode');

        if ($listingPages->isEmpty()) {
            return;
        }

        $menuTools->each(function ($uuid, $langcode) use ($listingPages) {
            $listingPage = $listingPages->get($langcode);

            HeaderMenuLink::query()->where('link', 'LIKE', "%custom|$uuid%")
                ->where('langcode', $langcode)
                ->update([
                    'link' => "tools_categories_listings|$listingPage",
                ]);
        });
    }
}
