<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class RequireVideoForVideoParagraph extends Migration
{
    public $withinTransaction = false;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        if (! InsideSchema::hasModel('video')) {
            return;
        }

        $bridge->contentTypeCreateOrUpdateField('video', 'file', [
            'name' => 'file',
            'required' => true,
        ], 0, 'paragraph');
    }
}
