<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CreateInsideLogsTable extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('inside_logs')) {
            Schema::dropIfExists('inside_logs');
        }

        Schema::create('inside_logs', function (Blueprint $table) {
            $table->uuid('uuid')->primary();
            $table->uuid('user_uuid')->nullable();
            $table->string('content_type')->nullable();
            $table->string('action')->nullable();
            $table->timestamp('created_at')->useCurrent();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_logs');
    }
}
