<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\ImageStyles;
use Inside\Host\Bridge\BridgeContent;

class UpdateImageCardStyle extends Migration
{
    public function up(): void
    {
        $imageCardStyle = ImageStyles::where('title', 'image_card')->first()?->uuid;
        if (! $imageCardStyle) {
            return;
        }

        $bridge = new BridgeContent();
        $bridge->contentUpdate(
            'image_styles',
            [
                'uuid'   => ImageStyles::where('title', 'image_card')->first()?->uuid,
                'resizable' => 1,
            ]
        );

        Artisan::call('inside:images:generate');
    }
}
