<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Services\QuickAccessService;
use Inside\Host\Bridge\BridgeContent;

final class RemoveRemovedToolsFromUsersConfig extends Migration
{
    public function up(): void
    {
        if (InsideSchema::hasModel(modelName: 'tools')) {
            $quickAccesService = new QuickAccessService();
            $quickAccesService->cleanUnpublishedTools();
        }
    }
}
