<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldColorToCustomPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        if (! InsideSchema::hasModel('custom')) {
            return;
        }

        $bridge->contentTypeCreateOrUpdateField('custom', 'color', [
            'name' => 'color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Couleur',
                'en' => 'Color',
                'es'=>'Color',
                'pt'=>'Cor',
                'de'=>'Farbe',
                'nl'=>'Kleur',
            ],
            'description' => [
                'en' => 'Select your folder color',
                'fr' => 'Sélectionnez la couleur de votre dossier',
                'es' => 'Seleccione el color de su carpeta',
                'pt' => 'Selecione a cor da sua pasta',
                'de' => 'Wählen Sie die Farbe Ihres Ordners',
                'nl' => 'Selecteer de kleur van uw map',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);
    }
}
