<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Content\Models\Sections\Video;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class AddDownloadButtonToVideoParagraph extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        if (! InsideSchema::hasModel('video') || InsideSchema::hasField('video', 'allow_download')) {
            return;
        }

        $bridge->contentTypeCreateOrUpdateField('video', 'allow_download', [
            'name' => 'allow_download',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Accepter le téléchargement par les utilisateurs',
                'en' => 'Accept downloads from users',
                'es' => 'Aceptar descargas de los usuarios',
                'pt' => 'Aceitar downloads dos usuários',
                'de' => 'Downloads von Benutzern akzeptieren',
                'nl' => 'Downloads van gebruikers accepteren',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => true,
        ], 1, 'paragraph');
    }
}
