<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

final class RemoveFieldShowIntroInContent extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        if (
            InsideSchema::hasModel(modelName: 'news') &&
            InsideSchema::hasField(modelName: 'news', fieldName: 'show_intro_in_content')
        ) {
            $bridgeContentType->contentTypeDeleteField(entityType: 'node', type: 'news', fieldName: 'show_intro_in_content');
            Artisan::call('models:rebuild');
        }
    }
}
