<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

final class AddFieldShowIntroInContent extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        if (! InsideSchema::hasModel('news')) {
            return;
        }

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'news',
            fieldName: 'show_intro_in_content',
            options: [
                'name' => 'show_intro_in_content',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Remonter l\'introduction dans le contenu',
                    'en' => 'Show introduction within content',
                    'de' => 'Einleitung im Inhalt anzeigen',
                    'nl' => 'Introductie in de inhoud weergeven',
                    'pt' => 'Mostrar introdução no conteúdo',
                    'es' => 'Mostrar la introducción dentro del contenido',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ]
        );
    }
}
