<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class RenameFolderTitle extends Migration
{
    public function up(): void
    {
        if (! InsideSchema::hasModel('folders')) {
            return;
        }

        $bridge = new BridgeContentType();
        $bridge->contentTypeUpdateField(
            'folders',
            'folders',
            [
                'name' => 'folders',
                'translatable' => true,
                'title' => [
                    'fr' => 'Dossier parent',
                    'en' => 'Parent Folder',
                    'de' => 'Übergeordneter Ordner',
                    'nl' => 'Bovenliggende map',
                    'pt' => 'Pasta principal',
                    'es' => 'Carpeta principal',
                ],
            ],
            2,
            'node'
        );
    }
}
