<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class FixLanguageMissingInAdvancedOptions extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        foreach (Schema::getContentTypes() as $type) {
            if (Schema::getModelOptions($type)['translatable']
                && Schema::hasField($type, 'langcode')
                && ! Schema::getFieldOptions($type, 'langcode')['displayed']) {
                $bridge->changeFieldFormOptions($type, 'langcode', true, 'group_advanced_options');
            }
        }
    }
}
