<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CreateUserContentSeenTable extends Migration
{
    public function up(): void
    {
        Schema::dropIfExists('inside_user_news_seen');
        Schema::dropIfExists('inside_user_content_seen');

        Schema::create('inside_user_content_seen', function (Blueprint $table) {
            $table->uuid('user_uuid');
            $table->string('seen_type');
            $table->char('seen_uuid', 36);
            $table->primary(['seen_type', 'seen_uuid', 'user_uuid']);
            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_user_content_seen');
    }
}
