<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Support\Str;

class DeleteAllAltFields extends Migration
{
    use HasConsole;

    public function up(): void
    {
        $bridge = new BridgeContentType();
        collect(Schema::models())->mapWithKeys(function ($value, $type) use ($bridge) {
            $fields = array_keys($value['fields']);
            $node = $type === 'users' ? 'user' : 'node';
            $type = $type === 'users' ? 'user' : $type;

            foreach ($fields as $field) {
                if (Str::endsWith((string) $field, '_alt')) {
                    $this->writeln(sprintf('deleting field %s for type %s', $field, $type));
                    $bridge->contentTypeDeleteField($node, $type, $field);
                }
            }
        });
    }
}
