<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class AddRgaaTitleToLinksForAccessibility extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $fieldsWidgetTypes = ['inside_link_field_widget'];

        foreach ($fieldsWidgetTypes as $widgetType) {
            $returnedFields = Schema::getAllFieldsListingOfWidget($widgetType);

            $listOfFieldsDescriptionsPerLanguage = [
                'fr' => 'Cet élément ne s\'affichera pas en front office mais permettra d\'indiquer aux personnes malvoyantes à quoi correspond l\'élément complété ci-dessus',
                'en' => 'This element will not be displayed on the front office but will allow us to indicate to the visually impaired to which the element completed above',
                'es' => 'Este elemento no se mostrará en la oficina principal, sino que nos permitirá indicar al inmemberd visualmente al que el elemento completamente',
                'pt' => 'Este elemento não será exibido no escritório da frente, mas nos permitirá indicar para o visualmente iminente ao qual o elemento completamente',
                'de' => 'Dieses Element wird nicht im Front Office angezeigt, ermöglicht es uns, dem visuellen Immemberd, dem das Element vollständig',
                'nl' => 'Dit element wordt niet weergegeven op de front office, maar stelt ons in staat om de visueel immemberd aan te geven waaraan het element volledig is',
            ];

            foreach ($returnedFields as $item) {
                if (Schema::hasField($item[0], $item[1].'_alt')) {
                    continue;
                }
                $options = Schema::getFieldOptions($item[0], $item[1]);

                $bridge->contentTypeCreateOrUpdateField($item[0], $item[1].'_alt', [
                    'name' => $item[1].'_alt',
                    'searchable' => false,
                    'translatable' => false,
                    'search_result_field' => false,
                    'search_filter' => false,
                    'required' => true,
                    'weight' => 1,
                    'title'=>collect($options['title'])->transform(fn ($title) =>'Alt '.$title)->toArray(),
                    'description' => collect($listOfFieldsDescriptionsPerLanguage)->intersectByKeys(collect($options['title']))->toArray(),
                    'widget' => [
                        'type' => BridgeContentType::STRING_WIDGET,
                        'settings' => [
                            'size' => 60,
                            'placeholder' => '',
                        ],
                        'weight' => 1,
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ],
                ], null, 'node');
            }
        }
    }
}
