<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class AddFieldOpenInNewTabToParagraphButton extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (! Schema::hasModel('button')) {
            return;
        }

        $this->bootUp(__FILE__);

        $this->getBridge()?->contentTypeCreateField(
            type: 'button',
            fieldName: 'open_in_new_tab',
            options: [
                'name' => 'open_in_new_tab',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Ouvrir dans un nouvel onglet',
                    'en' => 'Open in new tab',
                    'es' => 'Abrir en una nueva pestaña',
                    'de' => 'In neuer Registerkarte öffnen',
                    'pt' => 'Abrir num novo separador',
                    'nl' => 'In nieuw tabblad openen',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ],
            weight: 5, entityTypeId: 'paragraph'
        );
        $this->finishUp();
    }
}
