<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class AddFlashNewsFields extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (! Schema::hasModel('flash_news')) {
            return;
        }

        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'flash_news',
            fieldName: 'background_color',
            options: [
                'name' => 'background_color',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Couleur du fond',
                    'en' => 'Background color',
                    'es' => 'Color de fondo',
                    'de' => 'Hintergrundfarbe',
                    'pt' => 'Cor de fundo',
                    'nl' => 'Achtergrondkleur',
                ],
                'description' => [
                    'fr' => "Si aucune couleur n'est sélectionnée, la couleur secondaire du site sera utilisée.",
                    'en' => 'If no color is selected, the secondary color of the website will be used.',
                    'es' => 'Si no se selecciona ningún color, se utilizará el color secundario del sitio web.',
                    'de' => 'Wenn keine Farbe ausgewählt ist, wird die sekundäre Farbe der Website verwendet.',
                    'pt' => 'Se nenhuma cor for selecionada, será utilizada a cor secundária do site.',
                    'nl' => 'Als er geen kleur is geselecteerd, wordt de secundaire kleur van de website gebruikt.',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                    'settings' => [],
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: -2
        );

        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'flash_news',
            fieldName: 'dark_mode',
            options: [
                'name' => 'dark_mode',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'title' => [
                    'fr' => "Passer le titre et l'icône en blanc",
                    'en' => 'Set the title and icon to white',
                    'es' => 'Pasar el título y el icono a blanco',
                    'de' => 'Den Titel und das Symbol auf Weiß setzen',
                    'pt' => 'Definir o título e o ícone como branco',
                    'nl' => 'Zet de titel en het pictogram op wit',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => true,
            ],
            weight: -2
        );
        $this->finishUp();
    }
}
