<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Inside\Content\Models\Sections\FetchedContents;

final class RepairMultilingualSectionFetchedContents extends Migration
{
    public function up(): void
    {
        Artisan::call('models:rebuild');

        if (! class_exists(section_type_to_class('fetched_contents'))) {
            return;
        }

        FetchedContents::all()
            ->each(function (FetchedContents $section) {
                $oldSelection = $section->selection;

                $uuids = $this->getUuidsFromSelection($oldSelection, $section->langcode);

                $newSelection = type_to_class($section->content_type)::query()
                    ->whereIn('uuid', $uuids)
                    ->pluck('uuid_host')
                    ->join(',') ?: null;

                $section->update(['selection' => $newSelection]);

                DB::table('paragraph__field_selection')
                    ->where('field_selection_value', $oldSelection)
                    ->update(['field_selection_value' => $newSelection]);
            });
    }

    private function getUuidsFromSelection(?string $selection, string $langcode): array
    {
        if (empty($selection)) {
            return [];
        }

        if (Str::contains($selection, '{')) { // field is json
            $json = json_decode($selection, true);

            return $json[$langcode] ?? [];
        }

        return explode(',', $selection);
    }
}
