<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class AddPagesCategoriesIconColorField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        if (Schema::hasModel('pages_categories')) {
            $this->getBridge()?->contentTypeCreateOrUpdateField(
                'pages_categories',
                'icon_color',
                [
                    'name' => 'icon_color',
                    'searchable' => false,
                    'translatable' => false,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 4,
                    'title' => [
                        'fr' => "Couleur de l'icône",
                    ],
                    'widget' => [
                        'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                        'settings' => [],
                        'weight' => 4,
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ],
                ],
                4
            );
        }
        $this->finishUp();
    }
}
