<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class ImproveFetchedContentsPagination extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (Schema::hasField('fetched_contents', 'number_pages')) {
            tap(new BridgeContentType())->contentTypeDeleteField(
                entityType: 'paragraph',
                type: 'fetched_contents',
                fieldName: 'number_pages'
            );
        }

        $this->bootUp(__FILE__);
        $this->migrateContent('fetched_contents', false, 'sections');
        $this->finishUp();
    }
}
